/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import unluac.parse.LNumber;
import unluac.parse.LNumberType;

class LFloatNumber
extends LNumber {
    public final float number;
    public final LNumberType.NumberMode mode;

    public LFloatNumber(float number, LNumberType.NumberMode mode) {
        this.number = number;
        this.mode = mode;
    }

    @Override
    public String toPrintString() {
        if (this.mode == LNumberType.NumberMode.MODE_NUMBER && this.number == (float)Math.round(this.number)) {
            if (Float.floatToRawIntBits(this.number) == Float.floatToRawIntBits(-0.0f)) {
                return "-0";
            }
            return Integer.toString((int)this.number);
        }
        return Float.toString(this.number);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LFloatNumber) {
            return Float.floatToRawIntBits(this.number) == Float.floatToRawIntBits(((LFloatNumber)o).number);
        }
        if (o instanceof LNumber) {
            return this.value() == ((LNumber)o).value();
        }
        return false;
    }

    @Override
    public double value() {
        return this.number;
    }

    @Override
    public boolean integralType() {
        return false;
    }

    @Override
    public long bits() {
        return Float.floatToRawIntBits(this.number);
    }
}

