/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import unluac.Version;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BList;
import unluac.parse.BObjectType;
import unluac.parse.LAbsLineInfo;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType50;
import unluac.parse.LFunctionType51;
import unluac.parse.LFunctionType52;
import unluac.parse.LFunctionType53;
import unluac.parse.LFunctionType54;
import unluac.parse.LHeader;
import unluac.parse.LLocal;
import unluac.parse.LObject;
import unluac.parse.LString;
import unluac.parse.LUpvalue;

public abstract class LFunctionType
extends BObjectType<LFunction> {
    public static LFunctionType get(Version.FunctionType type) {
        switch (type) {
            case LUA50: {
                return new LFunctionType50();
            }
            case LUA51: {
                return new LFunctionType51();
            }
            case LUA52: {
                return new LFunctionType52();
            }
            case LUA53: {
                return new LFunctionType53();
            }
            case LUA54: {
                return new LFunctionType54();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public LFunction parse(ByteBuffer buffer, BHeader header) {
        header.getClass();
        header.getClass();
        LFunctionParseState s = new LFunctionParseState();
        this.parse_main(buffer, header, s);
        int[] lines = new int[s.lines.length.asInt()];
        int i = 0;
        while (i < lines.length) {
            lines[i] = s.lines.get(i).asInt();
            ++i;
        }
        LAbsLineInfo[] abslineinfo = null;
        if (s.abslineinfo != null) {
            abslineinfo = (LAbsLineInfo[])s.abslineinfo.asArray(new LAbsLineInfo[s.abslineinfo.length.asInt()]);
        }
        LFunction lfunc = new LFunction(header, s.name, s.lineBegin, s.lineEnd, s.code, lines, abslineinfo, (LLocal[])s.locals.asArray(new LLocal[s.locals.length.asInt()]), (LObject[])s.constants.asArray(new LObject[s.constants.length.asInt()]), s.upvalues, (LFunction[])s.functions.asArray(new LFunction[s.functions.length.asInt()]), s.maximumStackSize, s.lenUpvalues, s.lenParameter, s.vararg);
        LFunction[] lFunctionArray = lfunc.functions;
        int n = lfunc.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LFunction child = lFunctionArray[n2];
            child.parent = lfunc;
            ++n2;
        }
        if (s.lines.length.asInt() == 0 && s.locals.length.asInt() == 0) {
            lfunc.stripped = true;
        }
        return lfunc;
    }

    public abstract List<Directive> get_directives();

    protected abstract void parse_main(ByteBuffer var1, BHeader var2, LFunctionParseState var3);

    protected void parse_code(ByteBuffer buffer, BHeader header, LFunctionParseState s) {
        header.getClass();
        s.length = ((BInteger)header.integer.parse(buffer, header)).asInt();
        s.code = new int[s.length];
        int i = 0;
        while (i < s.length) {
            s.code[i] = buffer.getInt();
            header.getClass();
            ++i;
        }
    }

    protected void write_code(OutputStream out, BHeader header, LFunction object) throws IOException {
        header.integer.write(out, header, new BInteger(object.code.length));
        int i = 0;
        while (i < object.code.length) {
            int codepoint = object.code[i];
            if (header.lheader.endianness == LHeader.LEndianness.LITTLE) {
                out.write((byte)(0xFF & codepoint));
                out.write((byte)(0xFF & codepoint >> 8));
                out.write((byte)(0xFF & codepoint >> 16));
                out.write((byte)(0xFF & codepoint >> 24));
            } else {
                out.write((byte)(0xFF & codepoint >> 24));
                out.write((byte)(0xFF & codepoint >> 16));
                out.write((byte)(0xFF & codepoint >> 8));
                out.write((byte)(0xFF & codepoint));
            }
            ++i;
        }
    }

    protected void parse_constants(ByteBuffer buffer, BHeader header, LFunctionParseState s) {
        header.getClass();
        s.constants = header.constant.parseList(buffer, header);
        header.getClass();
        s.functions = header.function.parseList(buffer, header);
    }

    protected void write_constants(OutputStream out, BHeader header, LFunction object) throws IOException {
        header.constant.writeList(out, header, object.constants);
        header.function.writeList(out, header, object.functions);
    }

    protected void create_upvalues(ByteBuffer buffer, BHeader header, LFunctionParseState s) {
        s.upvalues = new LUpvalue[s.lenUpvalues];
        int i = 0;
        while (i < s.lenUpvalues) {
            s.upvalues[i] = new LUpvalue();
            ++i;
        }
    }

    protected void parse_upvalues(ByteBuffer buffer, BHeader header, LFunctionParseState s) {
        BList upvalues = header.upvalue.parseList(buffer, header);
        s.lenUpvalues = upvalues.length.asInt();
        s.upvalues = (LUpvalue[])upvalues.asArray(new LUpvalue[s.lenUpvalues]);
    }

    protected void write_upvalues(OutputStream out, BHeader header, LFunction object) throws IOException {
        header.upvalue.writeList(out, header, object.upvalues);
    }

    protected void parse_debug(ByteBuffer buffer, BHeader header, LFunctionParseState s) {
        header.getClass();
        s.lines = header.integer.parseList(buffer, header);
        header.getClass();
        s.locals = header.local.parseList(buffer, header);
        header.getClass();
        BList upvalueNames = header.string.parseList(buffer, header);
        int i = 0;
        while (i < upvalueNames.length.asInt()) {
            s.upvalues[i].bname = (LString)upvalueNames.get(i);
            s.upvalues[i].name = s.upvalues[i].bname.deref();
            ++i;
        }
    }

    protected void write_debug(OutputStream out, BHeader header, LFunction object) throws IOException {
        header.integer.write(out, header, new BInteger(object.lines.length));
        int i = 0;
        while (i < object.lines.length) {
            header.integer.write(out, header, new BInteger(object.lines[i]));
            ++i;
        }
        header.local.writeList(out, header, object.locals);
        int upvalueNameLength = 0;
        LUpvalue[] lUpvalueArray = object.upvalues;
        int n = object.upvalues.length;
        int n2 = 0;
        while (n2 < n) {
            LUpvalue upvalue = lUpvalueArray[n2];
            if (upvalue.bname == null || upvalue.bname == LString.NULL) break;
            ++upvalueNameLength;
            ++n2;
        }
        header.integer.write(out, header, new BInteger(upvalueNameLength));
        int i2 = 0;
        while (i2 < upvalueNameLength) {
            header.string.write(out, header, object.upvalues[i2].bname);
            ++i2;
        }
    }

    protected static class LFunctionParseState {
        public LString name;
        int lineBegin;
        int lineEnd;
        int lenUpvalues;
        int lenParameter;
        int vararg;
        int maximumStackSize;
        int length;
        int[] code;
        BList<LObject> constants;
        BList<LFunction> functions;
        BList<BInteger> lines;
        BList<LAbsLineInfo> abslineinfo;
        BList<LLocal> locals;
        LUpvalue[] upvalues;

        protected LFunctionParseState() {
        }
    }
}

