/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LString;

class LFunctionType50
extends LFunctionType {
    LFunctionType50() {
    }

    @Override
    protected void parse_main(ByteBuffer buffer, BHeader header, LFunctionType.LFunctionParseState s) {
        s.name = (LString)header.string.parse(buffer, header);
        s.lineBegin = ((BInteger)header.integer.parse(buffer, header)).asInt();
        s.lineEnd = 0;
        s.lenUpvalues = 0xFF & buffer.get();
        this.create_upvalues(buffer, header, s);
        s.lenParameter = 0xFF & buffer.get();
        s.vararg = 0xFF & buffer.get();
        s.maximumStackSize = 0xFF & buffer.get();
        this.parse_debug(buffer, header, s);
        this.parse_constants(buffer, header, s);
        this.parse_code(buffer, header, s);
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.SOURCE, Directive.LINEDEFINED, Directive.NUMPARAMS, Directive.IS_VARARG, Directive.MAXSTACKSIZE);
    }

    @Override
    public void write(OutputStream out, BHeader header, LFunction object) throws IOException {
        header.string.write(out, header, object.name);
        header.integer.write(out, header, new BInteger(object.linedefined));
        out.write(object.numUpvalues);
        out.write(object.numParams);
        out.write(object.vararg);
        out.write(object.maximumStackSize);
        this.write_debug(out, header, object);
        this.write_constants(out, header, object);
        this.write_code(out, header, object);
    }
}

