/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LString;

class LFunctionType53
extends LFunctionType {
    LFunctionType53() {
    }

    @Override
    protected void parse_main(ByteBuffer buffer, BHeader header, LFunctionType.LFunctionParseState s) {
        s.name = (LString)header.string.parse(buffer, header);
        s.lineBegin = ((BInteger)header.integer.parse(buffer, header)).asInt();
        s.lineEnd = ((BInteger)header.integer.parse(buffer, header)).asInt();
        s.lenParameter = 0xFF & buffer.get();
        s.vararg = 0xFF & buffer.get();
        s.maximumStackSize = 0xFF & buffer.get();
        this.parse_code(buffer, header, s);
        s.constants = header.constant.parseList(buffer, header);
        this.parse_upvalues(buffer, header, s);
        s.functions = header.function.parseList(buffer, header);
        this.parse_debug(buffer, header, s);
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.SOURCE, Directive.LINEDEFINED, Directive.LASTLINEDEFINED, Directive.NUMPARAMS, Directive.IS_VARARG, Directive.MAXSTACKSIZE);
    }

    @Override
    public void write(OutputStream out, BHeader header, LFunction object) throws IOException {
        header.string.write(out, header, object.name);
        header.integer.write(out, header, new BInteger(object.linedefined));
        header.integer.write(out, header, new BInteger(object.lastlinedefined));
        out.write(object.numParams);
        out.write(object.vararg);
        out.write(object.maximumStackSize);
        this.write_code(out, header, object);
        header.constant.writeList(out, header, object.constants);
        this.write_upvalues(out, header, object);
        header.function.writeList(out, header, object.functions);
        this.write_debug(out, header, object);
    }
}

