/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import unluac.Version;
import unluac.assemble.Directive;
import unluac.decompile.CodeExtract;
import unluac.parse.BHeader;
import unluac.parse.BIntegerType;
import unluac.parse.BIntegerType50;
import unluac.parse.BObjectType;
import unluac.parse.LAbsLineInfoType;
import unluac.parse.LBooleanType;
import unluac.parse.LConstantType;
import unluac.parse.LFunctionType;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType50;
import unluac.parse.LHeaderType51;
import unluac.parse.LHeaderType52;
import unluac.parse.LHeaderType53;
import unluac.parse.LHeaderType54;
import unluac.parse.LLocalType;
import unluac.parse.LNumberType;
import unluac.parse.LStringType;
import unluac.parse.LUpvalueType;

public abstract class LHeaderType
extends BObjectType<LHeader> {
    public static final LHeaderType TYPE50 = new LHeaderType50();
    public static final LHeaderType TYPE51 = new LHeaderType51();
    public static final LHeaderType TYPE52 = new LHeaderType52();
    public static final LHeaderType TYPE53 = new LHeaderType53();
    public static final LHeaderType TYPE54 = new LHeaderType54();
    private static final byte[] luacTail = new byte[]{25, -109, 13, 10, 26, 10};
    protected static final int TEST_INTEGER = 22136;
    protected static final double TEST_FLOAT = 370.5;

    public static LHeaderType get(Version.HeaderType type) {
        switch (type) {
            case LUA50: {
                return TYPE50;
            }
            case LUA51: {
                return TYPE51;
            }
            case LUA52: {
                return TYPE52;
            }
            case LUA53: {
                return TYPE53;
            }
            case LUA54: {
                return TYPE54;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public LHeader parse(ByteBuffer buffer, BHeader header) {
        Version version = header.version;
        LHeaderParseState s = new LHeaderParseState();
        this.parse_main(buffer, header, s);
        LBooleanType bool = new LBooleanType();
        LStringType string = version.getLStringType();
        LConstantType constant = version.getLConstantType();
        LAbsLineInfoType abslineinfo = new LAbsLineInfoType();
        LLocalType local = new LLocalType();
        LUpvalueType upvalue = version.getLUpvalueType();
        LFunctionType function = version.getLFunctionType();
        CodeExtract extract = new CodeExtract(header.version, s.sizeOp, s.sizeA, s.sizeB, s.sizeC);
        return new LHeader(s.format, s.endianness, s.integer, s.sizeT, bool, s.number, s.linteger, s.lfloat, string, constant, abslineinfo, local, upvalue, function, extract);
    }

    public abstract List<Directive> get_directives();

    protected abstract void parse_main(ByteBuffer var1, BHeader var2, LHeaderParseState var3);

    protected void parse_format(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int format = 0xFF & buffer.get();
        if (format != 0) {
            throw new IllegalStateException("The input chunk reports a non-standard lua format: " + format);
        }
        s.format = format;
        header.getClass();
    }

    protected void write_format(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write(object.format);
    }

    protected void parse_endianness(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int endianness = 0xFF & buffer.get();
        switch (endianness) {
            case 0: {
                s.endianness = LHeader.LEndianness.BIG;
                buffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 1: {
                s.endianness = LHeader.LEndianness.LITTLE;
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                throw new IllegalStateException("The input chunk reports an invalid endianness: " + endianness);
            }
        }
        header.getClass();
    }

    protected void write_endianness(OutputStream out, BHeader header, LHeader object) throws IOException {
        int value;
        switch (object.endianness) {
            case BIG: {
                value = 0;
                break;
            }
            case LITTLE: {
                value = 1;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        out.write(value);
    }

    protected void parse_int_size(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int intSize = 0xFF & buffer.get();
        header.getClass();
        s.integer = new BIntegerType50(intSize);
    }

    protected void write_int_size(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write(object.integer.getSize());
    }

    protected void parse_size_t_size(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int sizeTSize = 0xFF & buffer.get();
        header.getClass();
        s.sizeT = new BIntegerType50(sizeTSize);
    }

    protected void write_size_t_size(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write(object.sizeT.getSize());
    }

    protected void parse_instruction_size(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int instructionSize = 0xFF & buffer.get();
        header.getClass();
        if (instructionSize != 4) {
            throw new IllegalStateException("The input chunk reports an unsupported instruction size: " + instructionSize + " bytes");
        }
    }

    protected void write_instruction_size(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write(4);
    }

    protected void parse_number_size(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int lNumberSize = 0xFF & buffer.get();
        header.getClass();
        s.lNumberSize = lNumberSize;
    }

    protected void write_number_size(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write(object.number.size);
    }

    protected void parse_number_integrality(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int lNumberIntegralityCode = 0xFF & buffer.get();
        header.getClass();
        if (lNumberIntegralityCode > 1) {
            throw new IllegalStateException("The input chunk reports an invalid code for lua number integrality: " + lNumberIntegralityCode);
        }
        s.lNumberIntegrality = lNumberIntegralityCode == 1;
    }

    protected void write_number_integrality(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write((byte)(object.number.integral ? 1 : 0));
    }

    protected void parse_integer_size(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int lIntegerSize = 0xFF & buffer.get();
        header.getClass();
        if (lIntegerSize < 2) {
            throw new IllegalStateException("The input chunk reports an integer size that is too small: " + lIntegerSize);
        }
        s.lIntegerSize = lIntegerSize;
    }

    protected void parse_float_size(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int lFloatSize = 0xFF & buffer.get();
        header.getClass();
        s.lFloatSize = lFloatSize;
    }

    protected void parse_number_format_53(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        byte[] endianness = new byte[s.lIntegerSize];
        buffer.get(endianness);
        byte test_high = 86;
        byte test_low = 120;
        if (endianness[0] == test_low && endianness[1] == test_high) {
            s.endianness = LHeader.LEndianness.LITTLE;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else if (endianness[s.lIntegerSize - 1] == test_low && endianness[s.lIntegerSize - 2] == test_high) {
            s.endianness = LHeader.LEndianness.BIG;
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            throw new IllegalStateException("The input chunk reports an invalid endianness: " + Arrays.toString(endianness));
        }
        s.linteger = new LNumberType(s.lIntegerSize, true, LNumberType.NumberMode.MODE_INTEGER);
        s.lfloat = new LNumberType(s.lFloatSize, false, LNumberType.NumberMode.MODE_FLOAT);
        double floatcheck = s.lfloat.parse(buffer, header).value();
        if (floatcheck != s.lfloat.convert(370.5)) {
            throw new IllegalStateException("The input chunk is using an unrecognized floating point format: " + floatcheck);
        }
    }

    protected void parse_extractor(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        s.sizeOp = 0xFF & buffer.get();
        s.sizeA = 0xFF & buffer.get();
        s.sizeB = 0xFF & buffer.get();
        s.sizeC = 0xFF & buffer.get();
        header.getClass();
    }

    protected void write_extractor(OutputStream out, BHeader header, LHeader object) throws IOException {
        out.write(object.extractor.op.size);
        out.write(object.extractor.A.size);
        out.write(object.extractor.B.size);
        out.write(object.extractor.C.size);
    }

    protected void parse_tail(ByteBuffer buffer, BHeader header, LHeaderParseState s) {
        int i = 0;
        while (i < luacTail.length) {
            if (buffer.get() != luacTail[i]) {
                throw new IllegalStateException("The input file does not have the header tail of a valid Lua file (it may be corrupted).");
            }
            ++i;
        }
    }

    protected void write_tail(OutputStream out, BHeader header, LHeader object) throws IOException {
        int i = 0;
        while (i < luacTail.length) {
            out.write(luacTail[i]);
            ++i;
        }
    }

    protected static class LHeaderParseState {
        BIntegerType integer;
        BIntegerType sizeT;
        LNumberType number;
        LNumberType linteger;
        LNumberType lfloat;
        int format;
        LHeader.LEndianness endianness;
        int lNumberSize;
        boolean lNumberIntegrality;
        int lIntegerSize;
        int lFloatSize;
        int sizeOp;
        int sizeA;
        int sizeB;
        int sizeC;

        protected LHeaderParseState() {
        }
    }
}

