/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType;
import unluac.parse.LNumberType;

class LHeaderType50
extends LHeaderType {
    private static final double TEST_NUMBER = 3.1415926535897933E7;

    LHeaderType50() {
    }

    @Override
    protected void parse_main(ByteBuffer buffer, BHeader header, LHeaderType.LHeaderParseState s) {
        s.format = 0;
        this.parse_endianness(buffer, header, s);
        this.parse_int_size(buffer, header, s);
        this.parse_size_t_size(buffer, header, s);
        this.parse_instruction_size(buffer, header, s);
        this.parse_extractor(buffer, header, s);
        this.parse_number_size(buffer, header, s);
        LNumberType lfloat = new LNumberType(s.lNumberSize, false, LNumberType.NumberMode.MODE_NUMBER);
        LNumberType linteger = new LNumberType(s.lNumberSize, true, LNumberType.NumberMode.MODE_NUMBER);
        buffer.mark();
        double floatcheck = lfloat.parse(buffer, header).value();
        buffer.reset();
        double intcheck = linteger.parse(buffer, header).value();
        if (floatcheck == lfloat.convert(3.1415926535897933E7)) {
            s.number = lfloat;
        } else if (intcheck == linteger.convert(3.1415926535897933E7)) {
            s.number = linteger;
        } else {
            throw new IllegalStateException("The input chunk is using an unrecognized number format: " + intcheck);
        }
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.ENDIANNESS, Directive.INT_SIZE, Directive.SIZE_T_SIZE, Directive.INSTRUCTION_SIZE, Directive.SIZE_OP, Directive.SIZE_A, Directive.SIZE_B, Directive.SIZE_C, Directive.NUMBER_FORMAT);
    }

    @Override
    public void write(OutputStream out, BHeader header, LHeader object) throws IOException {
        this.write_endianness(out, header, object);
        this.write_int_size(out, header, object);
        this.write_size_t_size(out, header, object);
        this.write_instruction_size(out, header, object);
        this.write_extractor(out, header, object);
        this.write_number_size(out, header, object);
        object.number.write(out, header, object.number.create(3.1415926535897933E7));
    }
}

