/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType;
import unluac.parse.LNumberType;

class LHeaderType51
extends LHeaderType {
    LHeaderType51() {
    }

    @Override
    protected void parse_main(ByteBuffer buffer, BHeader header, LHeaderType.LHeaderParseState s) {
        this.parse_format(buffer, header, s);
        this.parse_endianness(buffer, header, s);
        this.parse_int_size(buffer, header, s);
        this.parse_size_t_size(buffer, header, s);
        this.parse_instruction_size(buffer, header, s);
        this.parse_number_size(buffer, header, s);
        this.parse_number_integrality(buffer, header, s);
        s.number = new LNumberType(s.lNumberSize, s.lNumberIntegrality, LNumberType.NumberMode.MODE_NUMBER);
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.FORMAT, Directive.ENDIANNESS, Directive.INT_SIZE, Directive.SIZE_T_SIZE, Directive.INSTRUCTION_SIZE, Directive.NUMBER_FORMAT);
    }

    @Override
    public void write(OutputStream out, BHeader header, LHeader object) throws IOException {
        this.write_format(out, header, object);
        this.write_endianness(out, header, object);
        this.write_int_size(out, header, object);
        this.write_size_t_size(out, header, object);
        this.write_instruction_size(out, header, object);
        this.write_number_size(out, header, object);
        this.write_number_integrality(out, header, object);
    }
}

