/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.BObjectType;
import unluac.parse.LDoubleNumber;
import unluac.parse.LFloatNumber;
import unluac.parse.LHeader;
import unluac.parse.LIntNumber;
import unluac.parse.LLongNumber;
import unluac.parse.LNumber;

public class LNumberType
extends BObjectType<LNumber> {
    public final int size;
    public final boolean integral;
    public final NumberMode mode;

    public LNumberType(int size, boolean integral, NumberMode mode) {
        this.size = size;
        this.integral = integral;
        this.mode = mode;
        if (size != 4 && size != 8) {
            throw new IllegalStateException("The input chunk has an unsupported Lua number size: " + size);
        }
    }

    public double convert(double number) {
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    return (int)number;
                }
                case 8: {
                    return (long)number;
                }
            }
        } else {
            switch (this.size) {
                case 4: {
                    return (float)number;
                }
                case 8: {
                    return number;
                }
            }
        }
        throw new IllegalStateException("The input chunk has an unsupported Lua number format");
    }

    @Override
    public LNumber parse(ByteBuffer buffer, BHeader header) {
        LNumber value = null;
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    value = new LIntNumber(buffer.getInt());
                    break;
                }
                case 8: {
                    value = new LLongNumber(buffer.getLong());
                }
            }
        } else {
            switch (this.size) {
                case 4: {
                    value = new LFloatNumber(buffer.getFloat(), this.mode);
                    break;
                }
                case 8: {
                    value = new LDoubleNumber(buffer.getDouble(), this.mode);
                }
            }
        }
        if (value == null) {
            throw new IllegalStateException("The input chunk has an unsupported Lua number format");
        }
        header.getClass();
        return value;
    }

    @Override
    public void write(OutputStream out, BHeader header, LNumber n) throws IOException {
        long bits = n.bits();
        if (header.lheader.endianness == LHeader.LEndianness.LITTLE) {
            int i = 0;
            while (i < this.size) {
                out.write((byte)(bits & 0xFFL));
                bits >>>= 8;
                ++i;
            }
        } else {
            int i = this.size - 1;
            while (i >= 0) {
                out.write((byte)(bits >> i * 8 & 0xFFL));
                --i;
            }
        }
    }

    public LNumber create(double x) {
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    return new LIntNumber((int)x);
                }
                case 8: {
                    return new LLongNumber((long)x);
                }
            }
            throw new IllegalStateException();
        }
        switch (this.size) {
            case 4: {
                return new LFloatNumber((float)x, this.mode);
            }
            case 8: {
                return new LDoubleNumber(x, this.mode);
            }
        }
        throw new IllegalStateException();
    }

    public LNumber create(BigInteger x) {
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    return new LIntNumber(x.intValueExact());
                }
                case 8: {
                    return new LLongNumber(x.longValueExact());
                }
            }
            throw new IllegalStateException();
        }
        switch (this.size) {
            case 4: {
                return new LFloatNumber(x.floatValue(), this.mode);
            }
            case 8: {
                return new LDoubleNumber(x.doubleValue(), this.mode);
            }
        }
        throw new IllegalStateException();
    }

    public static enum NumberMode {
        MODE_NUMBER,
        MODE_FLOAT,
        MODE_INTEGER;

    }
}

