/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LString;
import unluac.parse.LStringType;

class LStringType50
extends LStringType {
    LStringType50() {
    }

    @Override
    public LString parse(final ByteBuffer buffer, BHeader header) {
        BInteger sizeT = (BInteger)header.sizeT.parse(buffer, header);
        final StringBuilder b = (StringBuilder)this.b.get();
        b.setLength(0);
        sizeT.iterate(new Runnable(){

            @Override
            public void run() {
                b.append((char)(0xFF & buffer.get()));
            }
        });
        if (b.length() == 0) {
            return LString.NULL;
        }
        char last = b.charAt(b.length() - 1);
        if (last != '\u0000') {
            throw new IllegalStateException("String value does not have a null terminator");
        }
        b.delete(b.length() - 1, b.length());
        String s = b.toString();
        header.getClass();
        return new LString(s);
    }

    @Override
    public void write(OutputStream out, BHeader header, LString string) throws IOException {
        int len = string.value.length();
        if (string == LString.NULL) {
            header.sizeT.write(out, header, header.sizeT.create(0));
        } else {
            header.sizeT.write(out, header, header.sizeT.create(len + 1));
            int i = 0;
            while (i < len) {
                out.write(string.value.charAt(i));
                ++i;
            }
            out.write(0);
        }
    }
}

