/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import unluac.test.LuaSpec;

public class LuaC {
    public static void compile(LuaSpec spec, String in, String out) throws IOException {
        String luac = spec.getLuaCName();
        luac = System.getProperty(luac, luac);
        if (System.getProperty("os.name").contains("Windows")) {
            luac = String.valueOf(luac) + ".exe";
        }
        String[] args = spec.getArgs();
        String[] full = new String[4 + args.length];
        int i = 0;
        full[i++] = luac;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            full[i++] = arg;
            ++n2;
        }
        full[i++] = "-o";
        full[i++] = out;
        full[i++] = in;
        ProcessBuilder pb = new ProcessBuilder(full);
        pb.directory(null);
        Process p = pb.start();
        while (true) {
            try {
                if (p.waitFor() == 0) {
                    return;
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String line = null;
                do {
                    if ((line = r.readLine()) == null) continue;
                    System.err.println(line);
                } while (line != null);
                throw new IOException("luac failed on file: " + in);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

