/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

public class LuaSpec {
    private boolean isDefault;
    private int version;
    private int minorVersion;
    private NumberFormat numberFormat;
    private boolean strip;

    public LuaSpec() {
        this.isDefault = true;
        this.version = 0;
        this.numberFormat = NumberFormat.DEFAULT;
        this.strip = false;
    }

    public LuaSpec(int version) {
        this(version, -1);
    }

    public LuaSpec(int version, int minorVersion) {
        this.isDefault = false;
        this.version = version;
        this.minorVersion = minorVersion;
        this.numberFormat = NumberFormat.DEFAULT;
        this.strip = false;
    }

    public String id() {
        String id = "lua";
        id = String.valueOf(id) + Integer.toHexString(this.version);
        id = String.valueOf(id) + this.getMinorVersionString();
        return id;
    }

    public void setNumberFormat(NumberFormat format) {
        this.numberFormat = format;
    }

    public void setStrip(boolean strip) {
        this.strip = strip;
    }

    public String getLuaCName() {
        return "luac" + this.getVersionString() + this.getMinorVersionString() + this.getNumberFormatString();
    }

    public String[] getArgs() {
        if (this.strip) {
            return new String[]{"-s"};
        }
        return new String[0];
    }

    public boolean compatible(String filename) {
        int version = 0;
        int underscore = filename.indexOf(95);
        if (underscore != -1) {
            String prefix = filename.substring(0, underscore);
            try {
                version = Integer.parseInt(prefix, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return version == 0 || this.version >= version;
    }

    private String getVersionString() {
        if (this.isDefault) {
            return "";
        }
        return Integer.toHexString(this.version);
    }

    private String getMinorVersionString() {
        if (this.minorVersion >= 0) {
            return Integer.toString(this.minorVersion);
        }
        return "";
    }

    private String getNumberFormatString() {
        switch (this.numberFormat) {
            case DEFAULT: {
                return "";
            }
            case FLOAT: {
                return "_float";
            }
            case INT32: {
                return "_int32";
            }
            case INT64: {
                return "_int64";
            }
        }
        throw new IllegalStateException();
    }

    public static enum NumberFormat {
        DEFAULT,
        FLOAT,
        INT32,
        INT64;

    }
}

