/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import unluac.Configuration;
import unluac.test.LuaSpec;
import unluac.test.TestFile;
import unluac.test.TestReport;
import unluac.test.TestSuite;
import unluac.test.UnluacSpec;

public class RunExtendedTests {
    private static void gatherTests(Path base, Path folder, List<TestFile> files) throws IOException {
        for (Path file : Files.newDirectoryStream(folder, "*.lua")) {
            String relative = base.relativize(file).toString();
            files.add(new TestFile(relative.substring(0, relative.length() - 4)));
        }
        for (Path dir : Files.newDirectoryStream(folder)) {
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            RunExtendedTests.gatherTests(base, dir, files);
        }
    }

    public static void main(String[] args) throws IOException {
        FileSystem fs = FileSystems.getDefault();
        Path luatest = fs.getPath(args[0], new String[0]);
        TestReport report = new TestReport();
        Configuration config = new Configuration();
        int version = 80;
        while (version <= 84) {
            LuaSpec spec = new LuaSpec(version);
            UnluacSpec uspec = new UnluacSpec();
            System.out.println(spec.id());
            for (Path subfolder : Files.newDirectoryStream(luatest)) {
                if (!Files.isDirectory(subfolder, new LinkOption[0]) || !spec.compatible(subfolder.getFileName().toString())) continue;
                ArrayList<TestFile> files = new ArrayList<TestFile>();
                RunExtendedTests.gatherTests(subfolder, subfolder, files);
                TestSuite suite = new TestSuite(subfolder.getFileName().toString(), String.valueOf(subfolder.toString()) + File.separator, files.toArray(new TestFile[files.size()]));
                System.out.print("\t" + subfolder.getFileName().toString());
                suite.run(spec, uspec, report, config);
                System.out.println();
            }
            ++version;
        }
        report.report(System.out);
    }
}

