/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import unluac.test.TestResult;

public class TestReport {
    private int passed = 0;
    private int failed = 0;
    private int skipped = 0;
    private List<String> failedTests = new ArrayList<String>();
    private List<String> skippedTests = new ArrayList<String>();

    public void report(PrintStream out) {
        if (this.failed == 0 && this.skipped == 0) {
            out.println("All tests passed!");
        } else {
            for (String failed : this.failedTests) {
                out.println("Failed: " + failed);
            }
            for (String skipped : this.skippedTests) {
                out.println("Skipped: " + skipped);
            }
            out.println("Failed " + this.failed + " of " + (this.failed + this.passed) + " tests, skipped " + this.skipped + " tests.");
        }
    }

    public void result(String test, TestResult result) {
        switch (result) {
            case OK: {
                ++this.passed;
                break;
            }
            case FAILED: {
                this.failedTests.add(test);
                ++this.failed;
                break;
            }
            case SKIPPED: {
                this.skippedTests.add(test);
                ++this.skipped;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

