/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.File;
import java.io.IOException;
import unluac.Configuration;
import unluac.Main;
import unluac.assemble.AssemblerException;
import unluac.test.Compare;
import unluac.test.LuaC;
import unluac.test.LuaSpec;
import unluac.test.TestFile;
import unluac.test.TestReport;
import unluac.test.TestResult;
import unluac.test.UnluacSpec;

public class TestSuite {
    private static String working_dir = "./test/working/";
    private static String compiled = "luac.out";
    private static String decompiled = "unluac.out";
    private static String recompiled = "test.out";
    private String name;
    private String path;
    private TestFile[] files;
    private String ext = ".lua";

    public TestSuite(String name, String path, TestFile[] files) {
        this.name = name;
        this.path = path;
        this.files = files;
    }

    public String testName(LuaSpec spec, String file) {
        if (this.name == null) {
            return String.valueOf(spec.id()) + ": " + file;
        }
        return String.valueOf(spec.id()) + ": " + this.name + "/" + file.replace('\\', '/');
    }

    private TestResult test(LuaSpec spec, UnluacSpec uspec, String file, Configuration config) {
        try {
            LuaC.compile(spec, file, String.valueOf(working_dir) + compiled);
        }
        catch (IOException e) {
            return TestResult.SKIPPED;
        }
        try {
            uspec.run(String.valueOf(working_dir) + compiled, String.valueOf(working_dir) + decompiled, config);
            if (!uspec.disassemble) {
                LuaC.compile(spec, String.valueOf(working_dir) + decompiled, String.valueOf(working_dir) + recompiled);
            } else {
                Main.assemble(String.valueOf(working_dir) + decompiled, String.valueOf(working_dir) + recompiled);
            }
            Compare compare = !uspec.disassemble ? new Compare(Compare.Mode.NORMAL) : new Compare(Compare.Mode.FULL);
            return compare.bytecode_equal(String.valueOf(working_dir) + compiled, String.valueOf(working_dir) + recompiled) ? TestResult.OK : TestResult.FAILED;
        }
        catch (IOException e) {
            return TestResult.FAILED;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return TestResult.FAILED;
        }
        catch (AssemblerException e) {
            e.printStackTrace();
            return TestResult.FAILED;
        }
    }

    private TestResult testc(LuaSpec spec, UnluacSpec uspec, String file, Configuration config) {
        try {
            uspec.run(file, String.valueOf(working_dir) + decompiled, config);
            LuaC.compile(spec, String.valueOf(working_dir) + decompiled, String.valueOf(working_dir) + recompiled);
            Compare compare = new Compare(Compare.Mode.NORMAL);
            return compare.bytecode_equal(file, String.valueOf(working_dir) + recompiled) ? TestResult.OK : TestResult.FAILED;
        }
        catch (IOException e) {
            return TestResult.FAILED;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return TestResult.FAILED;
        }
    }

    public boolean run(LuaSpec spec, UnluacSpec uspec, TestReport report, Configuration base) throws IOException {
        int failed = 0;
        File working = new File(working_dir);
        if (!working.exists()) {
            working.mkdir();
        }
        TestFile[] testFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            TestFile testfile = testFileArray[n2];
            String name = testfile.name;
            if (spec.compatible(name)) {
                Configuration config = this.configure(testfile, base);
                TestResult result = this.test(spec, uspec, String.valueOf(this.path) + name + this.ext, config);
                report.result(this.testName(spec, name), result);
                switch (result) {
                    case OK: {
                        System.out.print(".");
                        break;
                    }
                    case SKIPPED: {
                        System.out.print(",");
                        break;
                    }
                    default: {
                        System.out.print("!");
                        ++failed;
                    }
                }
            }
            ++n2;
        }
        return failed == 0;
    }

    public boolean run(LuaSpec spec, UnluacSpec uspec, String file, boolean compiled, Configuration config) throws IOException {
        int passed = 0;
        int skipped = 0;
        int failed = 0;
        File working = new File(working_dir);
        if (!working.exists()) {
            working.mkdir();
        }
        String name = file;
        String full = !file.contains("/") ? String.valueOf(this.path) + name + this.ext : name;
        TestResult result = !compiled ? this.test(spec, uspec, full, config) : this.testc(spec, uspec, full, config);
        switch (result) {
            case OK: {
                System.out.println("Passed: " + name);
                ++passed;
                break;
            }
            case SKIPPED: {
                System.out.println("Skipped: " + name);
                ++skipped;
                break;
            }
            default: {
                System.out.println("Failed: " + name);
                ++failed;
            }
        }
        if (failed == 0 && skipped == 0) {
            System.out.println(String.valueOf(spec.getLuaCName()) + ": All tests passed!");
        } else {
            System.out.println(String.valueOf(spec.getLuaCName()) + ": Failed " + failed + " of " + (failed + passed) + " tests, skipped " + skipped + " tests.");
        }
        return failed == 0;
    }

    private Configuration configure(TestFile testfile, Configuration config) {
        Configuration modified = null;
        if (testfile.getFlag(1) && config.strict_scope) {
            modified = this.extend(config, modified);
            modified.strict_scope = false;
        }
        return modified != null ? modified : config;
    }

    private Configuration extend(Configuration base, Configuration modified) {
        return modified != null ? modified : new Configuration(base);
    }
}

