/*
 * Decompiled with CFR 0.152.
 */
package unluac.util;

public class StringUtils {
    public static String toPrintString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder();
        b.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c;
            char ci = c = s.charAt(i);
            if (c == '\"') {
                b.append("\\\"");
            } else if (c == '\\') {
                b.append("\\\\");
            } else if (ci >= ' ' && ci <= '~') {
                b.append(c);
            } else if (c == '\n') {
                b.append("\\n");
            } else if (c == '\t') {
                b.append("\\t");
            } else if (c == '\r') {
                b.append("\\r");
            } else if (c == '\b') {
                b.append("\\b");
            } else if (c == '\f') {
                b.append("\\f");
            } else if (ci == '\u000b') {
                b.append("\\v");
            } else if (ci == '\u0007') {
                b.append("\\a");
            } else {
                b.append(String.format("\\x%02x", ci));
            }
            ++i;
        }
        b.append('\"');
        return b.toString();
    }

    public static String fromPrintString(String s) {
        if (s.equals("null")) {
            return null;
        }
        if (s.charAt(0) != '\"') {
            throw new IllegalStateException("Bad string " + s);
        }
        if (s.charAt(s.length() - 1) != '\"') {
            throw new IllegalStateException("Bad string " + s);
        }
        StringBuilder b = new StringBuilder();
        int i = 1;
        while (i < s.length() - 1) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                if (i < s.length() - 1) {
                    if ((c = s.charAt(i++)) == '\"') {
                        b.append('\"');
                        continue;
                    }
                    if (c == '\\') {
                        b.append('\\');
                        continue;
                    }
                    if (c == 'n') {
                        b.append('\n');
                        continue;
                    }
                    if (c == 't') {
                        b.append('\t');
                        continue;
                    }
                    if (c == 'r') {
                        b.append('\r');
                        continue;
                    }
                    if (c == 'b') {
                        b.append('\b');
                        continue;
                    }
                    if (c == 'f') {
                        b.append('\f');
                        continue;
                    }
                    if (c == 'v') {
                        b.append('\u000b');
                        continue;
                    }
                    if (c == 'a') {
                        b.append('\u0007');
                        continue;
                    }
                    if (c == 'x') {
                        if (i + 1 < s.length() - 1) {
                            String digits = s.substring(i, i + 2);
                            i += 2;
                            b.append((char)Integer.parseInt(digits, 16));
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            b.append(c);
        }
        return b.toString();
    }

    private StringUtils() {
    }
}

