Config = {}

Config.NPCLocation = vector4(311.78, -595.82, 43.28, 75.0) -- Pillbox Hospital entrance (extremely reliable)
Config.NPCModel = 'g_m_y_mexgoon_01' -- More reliable model

-- Framework and notification settings
Config.Framework = 'qb' -- 'qb' or 'esx'
Config.Notification = 'qb' -- 'qb', 'esx', 'okok', 'ox'

-- Debug mode to help troubleshoot
Config.Debug = false

-- Interaction type configuration
Config.Interaction = 'draw' -- ox_target, qb-target, draw

-- Language settings - available: 'en', 'es', 'bg'
Config.Language = 'en'

-- Gang definitions
Config.Gangs = {
    {
        label = "Ballas", 
        value = "ballas", 
        description = "The Ballas control Davis and are known for their purple colors. They specialize in drug operations and territory control.",
        color = "#9B59B6", -- Purple color
        logo = "assets/ballas.png" -- Path to gang logo relative to html folder
    },
    {
        label = "Vagos", 
        value = "vagos", 
        description = "The Los Santos Vagos dominate Rancho and are recognized by their yellow colors. They're skilled in weapons trafficking and street warfare.",
        color = "#F1C40F", -- Yellow color
        logo = "assets/vagos.png" -- Path to gang logo
    },
    {
        label = "Families", 
        value = "families", 
        description = "The Families hold Chamberlain Hills and are identified by their green colors. They excel at protection rackets and local business control.",
        color = "#2ECC71", -- Green color
        logo = "assets/families.png" -- Path to gang logo
    },
    {
        label = "Lost MC", 
        value = "lostmc", 
        description = "The Lost Motorcycle Club operates throughout Blaine County. They specialize in arms dealing and illegal transportation networks.",
        color = "#34495E", -- Dark blue/gray color
        logo = "assets/lostmc.png" -- Path to gang logo
    },
}

-- UI Configuration
Config.UI = {
    mainLogo = "assets/main-logo.png" -- Logo displayed in the UI header
}

-- Discord webhook settings
Config.Discord = {
    enabled = true,                               -- Enable or disable Discord webhook notifications
    webhook = "YOUR_WEBHOOK_URL_HERE",            -- Discord webhook URL (add your webhook here)
    botName = "Gang Selection",                   -- Name for the webhook bot
    botImage = "https://i.imgur.com/KSvQ0XC.png", -- Avatar image URL for the webhook bot
    color = 3447003,                              -- Color for the embed (blue)
    footer = "Gang Selection System"              -- Footer text for the webhook
}

-- Language translations
Config.Translations = {
    ['en'] = {
        -- UI text
        ['title'] = "Gang Selection",
        ['subtitle'] = "Choose your allegiance",
        ['confirm_message'] = "Are you sure you want to join",
        ['card_view_text'] = "Click to view details",
        ['view_button'] = "View",
        ['join_button'] = "Join Gang",
        ['back_button'] = "Go Back",
        ['cancel_button'] = "Cancel",
        ['confirm_button'] = "Confirm",
        ['select_gang'] = "Select a gang from the list",
        ['permanent_choice'] = "This decision is final and cannot be changed later",
        ['confirm_selection'] = "Confirm Selection",
        ['description'] = "Description",
        ['about'] = "About",
        ['choose_gang'] = "Choose a gang to represent",
        
        -- Interaction text
        ['talk_to_recruiter'] = "Talk to Gang Recruiter",
        ['talk_key_prompt'] = "[E] Talk to Gang Recruiter",
        ['already_in_gang'] = "You are already a member of %s",
        ['joined_gang'] = "You joined the %s gang!",
        ['available'] = "Available"
    },
    
    ['es'] = {
        -- UI text
        ['title'] = "Selección de Banda",
        ['subtitle'] = "Elige tu lealtad",
        ['confirm_message'] = "¿Estás seguro de que quieres unirte a",
        ['card_view_text'] = "Haz clic para ver detalles",
        ['view_button'] = "Ver",
        ['join_button'] = "Unirse",
        ['back_button'] = "Volver",
        ['cancel_button'] = "Cancelar",
        ['confirm_button'] = "Confirmar",
        ['select_gang'] = "Selecciona una banda de la lista",
        ['permanent_choice'] = "Esta decisión es definitiva y no se puede cambiar más tarde",
        ['confirm_selection'] = "Confirmar Selección",
        ['description'] = "Descripción",
        ['about'] = "Acerca de",
        ['choose_gang'] = "Elige una banda para representar",
        
        -- Interaction text
        ['talk_to_recruiter'] = "Hablar con el Reclutador de Bandas",
        ['talk_key_prompt'] = "[E] Hablar con el Reclutador de Bandas",
        ['already_in_gang'] = "Ya eres miembro de %s",
        ['joined_gang'] = "¡Te has unido a la banda %s!",
        ['available'] = "Disponible"
    },
    
    ['bg'] = {
        -- UI text
        ['title'] = "Избор на банда",
        ['subtitle'] = "Избери твоята лоялност",
        ['confirm_message'] = "Сигурен ли си, че искаш да се присъединиш към",
        ['card_view_text'] = "Щракнете, за да видите подробности",
        ['view_button'] = "Преглед",
        ['join_button'] = "Присъединете се",
        ['back_button'] = "Назад",
        ['cancel_button'] = "Отказ",
        ['confirm_button'] = "Потвърждавам",
        ['select_gang'] = "Изберете банда от списъка",
        ['permanent_choice'] = "Това решение е окончателно и не може да бъде променено по-късно",
        ['confirm_selection'] = "Потвърждаване на избора",
        ['description'] = "Описание",
        ['about'] = "За бандата",
        ['choose_gang'] = "Изберете банда, която да представлявате",
        
        -- Interaction text
        ['talk_to_recruiter'] = "Говорете с рекрутера на банди",
        ['talk_key_prompt'] = "[E] Говорете с рекрутера на банди",
        ['already_in_gang'] = "Вече сте член на %s",
        ['joined_gang'] = "Присъединихте се към бандата %s!",
        ['available'] = "Наличен"
    }
}
